package de.mse.uebung7;

import java.util.ArrayList;
import java.util.LinkedList;

public class HashingChaining<Key, Value> {

   class Entry {

      final Key key;
      final Value value;

      public Entry(Key key, Value value) {
         this.key = key;
         this.value = value;
      }
   }

   private ArrayList<LinkedList<Entry>> table;

   public HashingChaining(int size) {
      this.table = new ArrayList<LinkedList<Entry>>(size);
      for (int i = 0; i < size; i++) {
         this.table.add(new LinkedList<Entry>());
      }
   }

   void put(Key key, Value value) {
      int offset = Math.abs(key.hashCode()) % table.size();
      LinkedList<Entry> entries = table.get(offset);
      Entry entry = new Entry(key, value);
      entries.add(entry);
   }

   Value get(Key key) {
      int offset = Math.abs(key.hashCode()) % table.size();
      LinkedList<Entry> entries = table.get(offset);

      for (Entry entry : entries) {
         if (entry.key.equals(key)) {
            return entry.value;
         }
      }

      return null;
   }
}
